clc
clear all
close all

load AALabData 
labfeat=FeaturesMatrix;
clear FeaturesMatrix

load AAMTData
mtfeat=FeaturesMatrix;

load AANewData
newfeat=FeaturesMatrix;

'Fraction of games with at least one strictly dominated action'
mean(labfeat(:,3))
mean(mtfeat(:,3))
mean(newfeat(:,3))

'Fraction of games with a "best for both" action profile'
mean(labfeat(:,4))
mean(mtfeat(:,4))
mean(newfeat(:,4))

'Number of different rows with a "max" payoff'
mean(labfeat(:,5))
mean(mtfeat(:,5))
mean(newfeat(:,5))

'Is there a level 1 action that is also part of a NE'
mean(labfeat(:,30))
mean(mtfeat(:,30))
mean(newfeat(:,30))


%% Make Figure, All Games

edges=[0,1,2,3,4,5];
figure
ax1 = subplot(1,2,1);
h1=histcounts(mtfeat(:,1),edges);
h1=h1./sum(h1);
h2=histcounts(labfeat(:,1),edges);
h2=h2./sum(h2);
h3=histcounts(newfeat(:,1),edges);
h3=h3./sum(h3);
b=bar([h1' h2' h3']);
b(1).FaceColor = 'b';
b(2).FaceColor = 'g';
legend('Random','Lab','Algo')
ylabel('Fraction of Games')
title('(a)')

clear h1 h2 h3

ax2 = subplot(1,2,2);
h1=histcounts(mtfeat(:,2),edges);
h1=h1./sum(h1);
h2=histcounts(labfeat(:,2),edges);
h2=h2./sum(h2);
h3=histcounts(newfeat(:,2),edges);
h3=h3./sum(h3);
b=bar([h1' h2' h3']);
b(1).FaceColor = 'b';
b(2).FaceColor = 'g';
legend('Random','Lab','Algo')
ylabel('Fraction of Games')
axis([1,5,0,inf])
title('(b)')

%% Make Figure, just Lab and Random

edges=[0,1,2,3,4,5];
figure
ax1 = subplot(1,2,1);
h1=histcounts(labfeat(:,1),edges);
h1=h1./sum(h1);
h2=histcounts(mtfeat(:,1),edges);
h2=h2./sum(h2);
b=bar([h1' h2']);
b(1).FaceColor = 'b';
b(2).FaceColor = 'g';
legend('Lab','Random')
ylabel('Fraction of Games')
title('(a)')

clear h1 h2 

ax2 = subplot(1,2,2);
h1=histcounts(labfeat(:,2),edges);
h1=h1./sum(h1);
h2=histcounts(mtfeat(:,2),edges);
h2=h2./sum(h2);
b=bar([h1' h2']);
b(1).FaceColor = 'b';
b(2).FaceColor = 'g';
legend('Lab','Random')
ylabel('Fraction of Games')
axis([1,5,0,inf])
title('(b)')


